#ifndef _keeloq2_h
#define _keeloq2_h

//double keeloq declarations 
//
#include <stdint.h>
#include "keeloq.h"


typedef KEELOQ_CODE KEELOQ_CODE2[2];
typedef uint8_t DEVICE;
typedef uint8_t SERIAL;

//4 bits are reserved for this
#define MAX_DEVICE_TYPES 3
#define KEYBOARD_DEVICE 0
#define SENSOR_DEVICE 1
#define ACTOR_DEVICE 2

//upper 4 bits of the device byte are reserved for the encryption method
#define KEELOQ2 0


typedef struct
	{
	KEELOQ_CODE2 keeloq;
	uint16_t counter;
	}
	device_entry;

typedef struct
        {
        KEELOQ_CODE2 keeloq;
        uint32_t counter;
        }
        device_entry32;

typedef struct
	{
	uint8_t random;
	DEVICE device;
	SERIAL serial;
	uint8_t padding_parity;
	}
	infodata;

typedef struct
	{
	uint32_t crypt[3];
	infodata data;
	}
	message;

//endianity-independent
//
#define MESSAGE_BYTES (sizeof(message))
typedef uint8_t portable_message[MESSAGE_BYTES];

void encrypt2(register uint32_t *code, const KEELOQ_CODE *key);
void decrypt2(register uint32_t *code, const KEELOQ_CODE *key);



void encrypt_message(message *m, portable_message em, const KEELOQ_CODE2 key);
uint8_t decrypt_message(message *m, portable_message em, uint8_t len, const KEELOQ_CODE2 **key);

extern uint8_t random_byte(void);
extern uint32_t atoi10_32(char *p);
extern char *itoa10_32(uint32_t n,char *p);

#ifndef NO_COUNTER16
void assemble_message(DEVICE device, SERIAL serial, const uint16_t counter, uint32_t payload, uint8_t rnd, message *m);
uint8_t disassemble_message(DEVICE *device, SERIAL *serial, uint16_t *counter, uint32_t *payload, const message *m);
uint8_t validate_message(DEVICE devicetype, SERIAL nserial, uint16_t *counters, uint16_t *resyncs, DEVICE device, SERIAL serial, uint16_t counter);
#endif

#ifdef COUNTER32
void assemble_message32(DEVICE device, SERIAL serial, uint32_t counter, uint32_t payload, uint8_t rnd, message *m);
uint8_t disassemble_message32(DEVICE *device, SERIAL *serial, uint32_t *counter, uint32_t *payload, const message *m);
uint8_t validate_message32(DEVICE devicetype, SERIAL nserial, uint32_t *counters, uint32_t *resyncs, DEVICE device, SERIAL serial, uint32_t counter, uint8_t longcounter);
#endif

typedef char PASSWORD[PASSWORD_LENGTH+1];
uint32_t makehash(uint32_t password, const uint64_t *salt);
int16_t checkpassword(uint32_t payload, uint8_t npass, const uint32_t *hashes,  uint64_t salt, uint8_t *lockunlock, char **suffix);
#endif
