
/*
 *     KeeLoq implementation for Atmel AVR
 *     Copyright (C) 2005 Jiri Pittner <jiri@pittnerovi.com>
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.

       This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *  
*/

#ifndef _keeloq_h
#define _keeloq_h

//keeloq declarations

typedef uint64_t KEELOQ_CODE;

void decrypt(register uint32_t *code, const KEELOQ_CODE *key);
void encrypt(register uint32_t *code, const KEELOQ_CODE *key);

#ifndef AVR_SOURCE
#define PSTR(x) x
#ifdef ARM_SOURCE
#define printP(x) print(x)
#else
#define printP(x) fprintf(stderr,x)
#endif
#endif




#endif
