#if ! defined (_devices433_h) 
#define _devices433_h

//longcounter flag, device type and command combine to one byte

//device types (sensors & actors)
#define THERMOSTAT 0x00
#define THERMOMETER 0x10
#define ALARMSENSOR 0x20
#define RELAY 0x30
#define AUTOLIGHT 0x40
#define LOCK 0x50
#define DEVICE06 0x60
#define MISCDEVICE 0x70
/*not more*/

#define LONGCOUNTER 0x80

//commands for AUTOLIGHT
#define SET_LUXTHR 0
#define SET_TIMING 1
#define FORCE_ONOFF 2

//commands for RELAY
#define RELAY_SET 0
#define RELAY_OR 1
#define RELAY_AND 2
#define RELAY_XOR 3
#define RELAY_TIMED 4

//commands for THERMOSTAT 
#define SET_REGIME 0
#define SET_TEMPERATURE 1
#define SET_HYSTON 2
#define SET_HYSTOFF 3
#define HEATCOOL_CTRL 4
#define GET_STATUS 5
#define SET_EFFECTIVE 6
#define RESET_HEATER 7
#define SET_OUTPUT_COUNTER 8
#define LOCK_TEMPSET 9

//commands for LOCK
//#define SET_OUTPUT_COUNTER 8
#define SET_PASSWORD_HASH 10

//reports from THERMOMETER (physically also from thermostat or any meteo sensor)
#define RESET_REPORT 0
#define TEMPERATURE_REPORT 1
#define REGIME_AND_HYST 2
#define TEMPSET_AND_HEATCOOL 3
#define TEMPERATURE_AND_HEATCOOL 4
#define EFFECTIVE_TEMP 5
#define COUNTER_OUTPUT_REPORT 6
#define PRESSURE_REPORT 7
#define HUMIDITY_REPORT 8
#define LIGHT_REPORT 9
#define WIND_REPORT 10
#define WIND_BLOW_REPORT 11
#define RAIN_REPORT 12
#define RAINFALL_REPORT 13


//report types from ALARMSENSOR
#define RESET_REPORT 0
#define SENSOR_REPORT 1
#define VOLTAGE_REPORT 3
#define PING_REPORT 6
#define ARM_REPORT 7
#define DISARM_REPORT 8


//status of ALARMSENSOR
//bits 0,1 are alarm_status
#define ALARM_ZKRAT 0
#define ALARM_KLID 1
#define ALARM_AKTIV_1 2
#define ALARM_AKTIV_2 3
#define ALARM_NOPING 5
#define ALARM_BADPASS 6


typedef char NAME8[8];
const NAME8 alarm_status[7] =
{
"zkrat",
"klid",
"aktiv_1",
"aktiv_2",
"aktiv_d", //delayed
"no_ping",
"bad_pass"
};


//regimes of thermostat
#define HEATER 1
#define COOLER 2
#define REMOTE 4
typedef char MENULABEL[9];
static const MENULABEL activelabel[5] = {"OFF","HEATER","COOLER","HEATCOOL","REMOTE"};

//direct remote control
#define HEATER_ON 1
#define HEATER_OFF 2
#define COOLER_ON 0x10
#define COOLER_OFF 0x20

//for effective temperature
#define UNDEFINED_HUMID -1
#define UNDEFINED_PRESSURE -1
#define UNDEFINED_LIGHT -1
#define UNDEFINED_TEMP -10000
#define AVERAGE 0
#define MINIMUM 1
#define MAXIMUM 2

static const MENULABEL eff_temp_label[3] = {"AVERAGE","MINIMUM","MAXIMUM"};

typedef struct 
	{
	uint8_t instr;
	uint8_t arg1;
	int16_t arg2;
	}
	__attribute__((packed))
	INSTRUCTION433;

typedef union
	{
	uint32_t code;
	INSTRUCTION433 cmd;
	}
	CODE433;

#endif
