/* Copyright (c) 2002, Marek Michalkiewicz
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE. */

/* $Id: timer.h,v 1.4 2003/06/10 19:12:25 arcanum Exp $ */

#ifndef _AVR_TIMER_H_
#define _AVR_TIMER_H_

#include <avr/io.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__AVR_ATmega128__)

/* Atmel changed the Clock Select Bit Description for timer0 on the
   mega128. */

enum {
  STOP             = 0,
  CK               = 1,
  CK8              = 2,
  CK32             = 3,
  CK64             = 4,
  CK128            = 5,
  CK256            = 6,
  CK1024           = 7,
};

#else

enum {
  STOP             = 0,
  CK               = 1,
  CK8              = 2,
  CK64             = 3,
  CK256            = 4,
  CK1024           = 5,
  T0_FALLING_EDGE  = 6,
  T0_RISING_EDGE   = 7
};

#endif

static inline void timer0_source (unsigned int src)
{
    TCCR0 = src;
}

static inline void timer0_stop (void)
{
    TCNT0 = 0;
}

static inline void timer0_start (void)
{
    TCNT0 = 1;
}

#ifdef __cplusplus
}
#endif

#endif /* _AVR_TIMER_H_ */
